# How to Use a Favicon Pack

A **favicon pack** typically includes a variety of image files and metadata to ensure your website's icon looks great across all platforms and devices, including desktops, mobile browsers, and bookmarks.

This guide explains how to implement a favicon pack into your website.

---

## 📁 What’s in the Favicon Pack?

A typical favicon pack might include:

- `favicon.ico` — Legacy icon for older browsers.
- `favicon.svg` — Scalable Vector Graphic for modern browsers.
- `apple-touch-icon.png` — For iOS home screen icons.
- `android-chrome-192x192.png`, `android-chrome-512x512.png` — For Android devices.
- `site.webmanifest` — Web App Manifest for progressive web apps.
- `browserconfig.xml` — For Windows tiles.
- PNGs of various sizes (`favicon-16x16.png`, `favicon-32x32.png`, etc.)

---

## 🧩 How to Install

### 1. Add Favicon Files to Your Website

Copy all the files from the favicon pack into your website's root folder (e.g. `/public` in a React or Next.js app, or `/` in a static site).

Example structure:
```
/public
  ├── favicon.ico
  ├── favicon.svg
  ├── apple-touch-icon.png
  ├── favicon-16x16.png
  ├── favicon-32x32.png
  ├── site.webmanifest
  └── browserconfig.xml
```

---

### 2. Add HTML Meta Tags

Place the following lines in the `<head>` of your HTML document:

```html
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="shortcut icon" href="/favicon.ico">
<link rel="icon" href="/favicon.svg" type="image/svg+xml">
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
<link rel="manifest" href="/site.webmanifest">
<meta name="msapplication-config" content="/browserconfig.xml">
<meta name="theme-color" content="#ffffff">
```

Make sure the `href` paths reflect the actual location of the files in your project.

---

### 3. Verify Implementation

Once deployed:

- Visit your site in different browsers and check the tab icon.
- Add the site to an iOS or Android home screen to confirm proper display.
- Use tools like [Real Favicon Generator Checker](https://realfavicongenerator.net/favicon_checker) to verify everything is configured correctly.

---

## 💡 Tips

- Regenerate your favicon pack if your branding or logo changes.
- Consider using [RealFaviconGenerator](https://realfavicongenerator.net/) to create a new pack.
- Keep the `site.webmanifest` and `browserconfig.xml` up to date if you use them.

---

## ✅ You're All Set!

With these steps complete, your website should display a consistent, branded favicon across all major devices and browsers.
